/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.PenguinConfig;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class PenguinEntity
extends Animal
implements ILexiconEntry {
    public PenguinEntity(EntityType<PenguinEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static boolean checkPenguinSpawnRules(EntityType<PenguinEntity> animal, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.PENGUIN_SPAWNABLE_ON) && PenguinEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob m_142606_(ServerLevel worldIn, AgeableMob parent) {
        return (AgeableMob)ModEntityTypes.PENGUIN.get().m_20615_((Level)worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, PenguinConfig.health()).m_22268_(Attributes.f_22279_, PenguinConfig.movementSpeed());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 8.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredients.PENGUIN_FOOD, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, PenguinEntity.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.PENGUIN_FOOD);
    }

    public boolean m_6040_() {
        return true;
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public int m_8100_() {
        return PenguinConfig.talkInterval();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.9f;
    }

    public int m_5792_() {
        return PenguinConfig.maxSpawnedInChunk();
    }

    protected SoundEvent m_7515_() {
        return ModSounds.PENGUIN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return ModSounds.PENGUIN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.PENGUIN_DEATH.get();
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.PENGUIN;
    }
}

